# SAAM Cabins - cPanel Deployment Guide

## 🚀 Subdomain Setup & Deployment Instructions

### Step 1: Create Subdomain in cPanel
1. **Access cPanel** → Go to "Subdomains" (under Domains section)
2. **Create Subdomain:**
   - Subdomain: `admin` (recommended) or `cms`
   - Domain: Select your main domain (e.g., saamcabins.com)
   - Document Root: `/public_html/admin` (auto-generated)
   - Click **"Create"**

### Step 2: Upload Website Files

#### Option A: Upload to Subdomain (Recommended)
```
Upload the 'dist' folder contents to:
/public_html/admin/
```

#### Option B: Upload to Main Domain
```
Upload the 'dist' folder contents to:
/public_html/
```

### Step 3: File Structure After Upload
```
/public_html/admin/
├── _next/
├── api/
├── admin/
├── about/
├── contact/
├── products/
├── work/
├── uploads/
├── data/
├── index.html
├── 404.html
└── ... other static files
```

### Step 4: Configure File Permissions
Set these permissions in cPanel File Manager:
- **Folders**: 755 or 750
- **Files**: 644 or 640
- **uploads/ folder**: 755 (for image uploads)
- **data/ folder**: 755 (for CMS data storage)

### Step 5: Environment Configuration
1. **Create .env.local** in your subdomain root:
```env
NEXTAUTH_SECRET=your-secret-key-here
NEXTAUTH_URL=https://admin.yourdomain.com
UPLOAD_DIR=/public_html/admin/uploads
```

### Step 6: Admin Access
After deployment, access your CMS at:
- **Admin Panel**: `https://admin.yourdomain.com/admin/login`
- **Dashboard**: `https://admin.yourdomain.com/admin/dashboard`
- **Main Website**: `https://admin.yourdomain.com`

### Step 7: Default Admin Credentials
```
Username: admin
Password: admin123
```
**⚠️ IMPORTANT**: Change these credentials immediately after first login!

## 📁 CMS Features Available

### Content Management
- ✅ **Company Information**: Logo, contact details, about content
- ✅ **Products**: Porta cabins, specifications, images
- ✅ **Features**: Homepage feature sections
- ✅ **Testimonials**: Customer reviews with ratings
- ✅ **Sliders**: Hero banners, image galleries, carousels
- ✅ **Pages**: Dynamic page creation and management

### Slider Management
- **Hero Sliders**: Homepage banner slides
- **Product Galleries**: Product image carousels
- **Testimonial Sliders**: Customer review carousels
- **Company Gallery**: Team and facility photos

### Image Management
- **Upload System**: Drag & drop image uploads
- **Media Library**: Organized file management
- **Automatic Optimization**: Responsive image handling

## 🔧 Technical Requirements

### Server Requirements
- **PHP**: 7.4+ (for file upload handling)
- **Apache/Nginx**: Web server
- **SSL Certificate**: Recommended for security
- **File Permissions**: Write access to uploads/ and data/ folders

### Browser Compatibility
- Modern browsers (Chrome, Firefox, Safari, Edge)
- Mobile responsive design
- Progressive Web App features

## 🚨 Security Recommendations

### 1. Change Default Credentials
- Update admin username and password
- Use strong passwords (12+ characters)

### 2. File Permissions
```bash
# Folders
chmod 755 /public_html/admin/uploads/
chmod 755 /public_html/admin/data/

# Files
chmod 644 /public_html/admin/data/*.json
```

### 3. SSL Certificate
- Install SSL certificate for your subdomain
- Force HTTPS redirects

### 4. Backup Strategy
- Regular backups of data/ folder
- Database backups (if using MySQL later)
- Full site backups weekly

## 📞 Support & Maintenance

### File Locations
- **CMS Data**: `/data/` folder (JSON files)
- **Uploads**: `/uploads/` folder
- **Configuration**: `.env.local` file

### Common Issues
1. **Upload Issues**: Check file permissions on uploads/ folder
2. **Login Problems**: Verify .env.local configuration
3. **Image Loading**: Ensure uploads/ folder is accessible via web

### Future Enhancements
- MySQL database integration
- Advanced user roles
- Email notification system
- SEO optimization tools
- Analytics integration

## 🎯 Quick Start Checklist

- [ ] Create subdomain in cPanel
- [ ] Upload dist/ folder contents
- [ ] Set file permissions (755/644)
- [ ] Create .env.local file
- [ ] Test admin login
- [ ] Change default password
- [ ] Upload company logo and images
- [ ] Configure slider content
- [ ] Test all CMS features

## 📚 Admin Panel Guide

### Login Process
1. Navigate to `/admin/login`
2. Enter credentials
3. Access dashboard at `/admin/dashboard`

### Managing Content
1. **Company Info**: Update business details, contact info
2. **Products**: Add/edit porta cabin products and specs
3. **Sliders**: Create dynamic image carousels
4. **Pages**: Build custom pages with rich content
5. **Media**: Upload and organize images

Your SAAM Cabins website with full CMS functionality is ready for deployment! 🎉